/*
 * Decompiled with CFR 0.152.
 */
package mso.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.CRC32;
import mso.generator.Choice;
import mso.generator.Limitation;
import mso.generator.Struct;
import mso.generator.TypeRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class Member {
    final TypeRegistry registry;
    final String name;
    private final String typeName;
    final String count;
    final String size;
    final String condition;
    final boolean isArray;
    final boolean isOptional;
    final boolean isInteger;
    final boolean isSimple;
    final boolean isStruct;
    final boolean isChoice;
    final Limitation[] limitations;

    Member(TypeRegistry typeRegistry, Element element) throws IOException {
        Object object;
        Object object2;
        this.registry = typeRegistry;
        this.name = element.getAttribute("name");
        this.condition = element.hasAttribute("condition") ? element.getAttribute("condition") : null;
        this.count = element.hasAttribute("count") ? element.getAttribute("count") : null;
        this.size = element.hasAttribute("size") ? element.getAttribute("size") : null;
        this.isOptional = element.hasAttribute("optional");
        boolean bl = this.isArray = this.count != null || element.hasAttribute("array");
        if (this.isOptional && this.isArray) {
            throw new IOException("Member " + this.name + " is optional and array, which is not allowed.");
        }
        if (element.hasAttribute("type")) {
            this.typeName = element.getAttribute("type");
            this.isInteger = false;
            this.isSimple = false;
            this.isChoice = false;
            this.isStruct = true;
        } else if (element.getNodeName().equals("choice")) {
            object2 = element.getElementsByTagName("type");
            object = "";
            ArrayList<Struct> arrayList = new ArrayList<Struct>();
            Element element2 = (Element)element.getParentNode().getParentNode();
            for (int i = 0; i < object2.getLength(); ++i) {
                String string = ((Element)object2.item(i)).getAttribute("type");
                Element element3 = Member.getStructElement(element2, string);
                object = (String)object + string;
                TypeRegistry.Type type = this.registry.getType(element3.getAttribute("name"));
                if (type instanceof Struct) {
                    arrayList.add((Struct)type);
                    continue;
                }
                arrayList.add(new Struct(this.registry, element3));
            }
            CRC32 cRC32 = new CRC32();
            cRC32.update(((String)object).getBytes());
            this.typeName = object = "choice" + cRC32.getValue();
            if (this.registry.getType(this.typeName) == null) {
                new Choice(this.registry, (String)object, arrayList, this.isOptional);
            }
            this.isInteger = false;
            this.isSimple = false;
            this.isChoice = true;
            this.isStruct = false;
        } else {
            this.typeName = element.getNodeName();
            this.isInteger = this.typeName.startsWith("int") || this.typeName.startsWith("uint");
            this.isSimple = true;
            this.isChoice = false;
            this.isStruct = false;
        }
        object2 = new ArrayList();
        object = element.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            if (!(object.item(i) instanceof Element)) continue;
            object2.add(new Limitation((Element)object.item(i)));
        }
        this.limitations = object2.toArray(new Limitation[0]);
    }

    public TypeRegistry.Type type() {
        return this.registry.getType(this.typeName);
    }

    private static Element getStructElement(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName("struct");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!element2.getAttribute("name").equals(string)) continue;
            return element2;
        }
        return null;
    }
}

