#include <glib/gi18n.h>
#include <locale.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdkkeysyms.h>

#define GETTEXT_PACKAGE "devicesetup"

#define WLAN_SW  	"/proc/wlan_sw"
#define BT_SW   	"/proc/bt_sw"
#define OJ6SH_WHEEL	"/proc/oj6sh_wheel"

#define ICON 	"/usr/share/pixmaps/devicesetup.png"


#define WLAN_ON_BUTTON_ACTIVE  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wlan_on_button),TRUE)
#define WLAN_OFF_BUTTON_ACTIVE gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wlan_off_button),TRUE)
#define BT_ON_BUTTON_ACTIVE    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(bt_on_button),TRUE)
#define BT_OFF_BUTTON_ACTIVE   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(bt_off_button),TRUE)
#define CURSOR_BUTTON_ACTIVE   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cursor_button),TRUE)
#define WHEEL_BUTTON_ACTIVE   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wheel_button),TRUE)

char wlan_value, bluetooth_value, optical_point_value;
static int wlan_status,bluetooth_status,optical_point_status,language_value;
static int wlan_ret,bluetooth_ret,op_ret;
//about window
GtkWidget *wnd;
GtkWidget *fixed;
//icon on top left corner
GdkPixbuf *wnd_icon_pixbuf;
//about wlan_on_button;
GtkWidget *wlan_on_button;
GtkWidget *wlan_on_alignment;
GtkWidget *wlan_on_hbox;
GtkWidget *wlan_on_image;
GtkWidget *wlan_on_label;
//about wlan_off_button;
GtkWidget *wlan_off_button;
GtkWidget *wlan_off_alignment;
GtkWidget *wlan_off_hbox;
GtkWidget *wlan_off_image;
GtkWidget *wlan_off_label;
//about bt_on_button;
GtkWidget *bt_on_button;
GtkWidget *bt_on_alignment;
GtkWidget *bt_on_hbox;
GtkWidget *bt_on_image;
GtkWidget *bt_on_label;
//about bt_off_button;
GtkWidget *bt_off_button;
GtkWidget *bt_off_alignment;
GtkWidget *bt_off_hbox;
GtkWidget *bt_off_image;
GtkWidget *bt_off_label;
//about cursor_button;
GtkWidget *cursor_button;
GtkWidget *cursor_alignment;
GtkWidget *cursor_hbox;
GtkWidget *cursor_image;
GtkWidget *cursor_label;
//about wheel_button;
GtkWidget *wheel_button;
GtkWidget *wheel_alignment;
GtkWidget *wheel_hbox;
GtkWidget *wheel_image;
GtkWidget *wheel_label;
//about radiobutton_group;
GSList 	  *wlan_group = NULL;
GSList 	  *bt_group = NULL;
GSList 	  *op_group = NULL;
//about labels;
GtkWidget *wlan_label;
GtkWidget *bluetooth_label;
GtkWidget *op_label;
//about dialog;
GtkWidget *wlan_read_dialog;
GtkWidget *wlan_write_dialog;
GtkWidget *bluetooth_read_dialog;
GtkWidget *bluetooth_write_dialog;
GtkWidget *optical_point_read_dialog;
GtkWidget *optical_point_write_dialog;
//about default_value;
GtkWidget *initialize_button;
//about close
GtkWidget *close_button;

GtkRadioAction *action;

//close func
gboolean release_resource(GtkWidget* widget,GdkEvent* event,gpointer data)
{
	gtk_main_quit();
	return FALSE;
}

void check_language()
{
	char *str;
	str=getenv("LANG");
	if((strcmp(str,"ja_JP.UTF-8"))==0)
		language_value=1;
	else
		language_value=0;
}

void wlan_on_selected()
{
	gtk_widget_show(wlan_on_image);
	gtk_widget_hide(wlan_off_image);
	gtk_alignment_set_padding (GTK_ALIGNMENT (wlan_on_alignment), 0, 0, 0, 3);
	gtk_alignment_set_padding (GTK_ALIGNMENT (wlan_off_alignment), 0, 0, 28, 0);
}

void wlan_off_selected()
{
	gtk_widget_show(wlan_off_image);
	gtk_widget_hide(wlan_on_image);
	gtk_alignment_set_padding (GTK_ALIGNMENT (wlan_off_alignment), 0, 0, 0, 3);
	gtk_alignment_set_padding (GTK_ALIGNMENT (wlan_on_alignment), 0, 0, 28, 0);

}

void bt_on_selected()
{
	gtk_widget_show(bt_on_image);
	gtk_widget_hide(bt_off_image);
	gtk_alignment_set_padding (GTK_ALIGNMENT (bt_on_alignment), 0, 0, 0, 3);
	gtk_alignment_set_padding (GTK_ALIGNMENT (bt_off_alignment), 0, 0, 28, 0);

}	

void bt_off_selected()
{
	gtk_widget_show(bt_off_image);
	gtk_widget_hide(bt_on_image);
	gtk_alignment_set_padding (GTK_ALIGNMENT (bt_off_alignment), 0, 0, 0, 3);
	gtk_alignment_set_padding (GTK_ALIGNMENT (bt_on_alignment), 0, 0, 28, 0);
}

void cursor_selected()
{

	if(language_value==1)
	{
		gtk_alignment_set_padding (GTK_ALIGNMENT (cursor_alignment), 0, 0, 0, 3);
		gtk_alignment_set_padding (GTK_ALIGNMENT (wheel_alignment), 0, 0, 28, 0);
	}	
	else
	{
		gtk_alignment_set_padding (GTK_ALIGNMENT (cursor_alignment), 0, 0, 0, 3);
		gtk_alignment_set_padding (GTK_ALIGNMENT (wheel_alignment), 0, 0, 28, 0);
	}
	gtk_widget_show(cursor_image);
	gtk_widget_hide(wheel_image);
}
//wheel mode selected
void wheel_selected()
{

	if(language_value==1)
	{
		gtk_alignment_set_padding (GTK_ALIGNMENT (wheel_alignment), 0, 0, 0, 3);
		gtk_alignment_set_padding (GTK_ALIGNMENT (cursor_alignment), 0, 0, 26, 0);
	}
	else
	{
		gtk_alignment_set_padding (GTK_ALIGNMENT (wheel_alignment), 0, 0, 0, 3);
		gtk_alignment_set_padding (GTK_ALIGNMENT (cursor_alignment), 0, 0, 26, 0);
	}
	gtk_widget_show(wheel_image);
	gtk_widget_hide(cursor_image);
}


//check status part
void check_wlan_status()
{
	char buf[128];
	char *buf2;
	buf2="          UP";
	FILE *p;
	
	if((p=popen("ifconfig eth0 | grep UP","r"))==NULL)
	{
		printf("popen() error!");
		exit(1);
	}
	
	fgets(buf,sizeof(buf),p);

	if((strncmp(buf2,buf,12))==0)
	{
		wlan_value=1;
		WLAN_ON_BUTTON_ACTIVE;
		wlan_on_selected();
	}
	else
	{
		wlan_value=0;
		WLAN_OFF_BUTTON_ACTIVE;
		wlan_off_selected();
	}
	pclose(p);
}

void check_bt_status()
{
	char buf[128];
	char *buf2;
	buf2="        UP";
	FILE *p;
	
	if((p=popen("hciconfig | grep UP","r"))==NULL)
	{
		printf("popen() error!");
		exit(1);
	}
	else	
		fgets(buf,sizeof(buf),p);

	if((strncmp(buf2,buf,10))==0)
	{	
		bluetooth_value=1;
		BT_ON_BUTTON_ACTIVE;
		bt_on_selected();
	}
	else
	{
		bluetooth_value=0;
		BT_OFF_BUTTON_ACTIVE;
		bt_off_selected();
	}
	pclose(p);
}

int get_wlan_status()
{
	FILE *fp;
	char value;
	int wlan_ret=-1;
	if((fp=fopen(WLAN_SW,"r"))==NULL)
	{
		wlan_status=0;
		printf("wlan_sw isn't exist!\n");
		check_wlan_status();
	}
	else
	{
		fclose(fp);
		FILE *fp2;
		if((fp2=fopen(WLAN_SW,"r+"))==NULL)
		{
			wlan_status=1;
			printf("wlan_sw read only!\n");
			check_wlan_status();
		}
		else
		{
			wlan_status=2;
			value=fgetc(fp2);
			if(value!=EOF)
			{
				if(value=='1')
				{
					WLAN_ON_BUTTON_ACTIVE;
					wlan_on_selected();
					wlan_ret=1;
				}
				else if(value=='0')
				{
					WLAN_OFF_BUTTON_ACTIVE;
					wlan_off_selected();
					wlan_ret=0;
				}
		
			}
			else
			{
				printf("wlan_sw has nothing!\n");
				check_wlan_status();
			}	
			fclose(fp2);
		}
	}
	return wlan_ret;
}

int get_bt_status()
{
	FILE *fp;
	char value;
	int bluetooth_ret=-1;
	if((fp=fopen(BT_SW,"r"))==NULL)
	{
		bluetooth_status=0;
		printf("bt_sw isn't exist!\n");
		check_bt_status();
	}
	else
	{
		fclose(fp);
		FILE *fp2;
		if((fp2=fopen(BT_SW,"r+"))==NULL)
		{
			bluetooth_status=1;
			printf("bt_sw read only!\n");
			check_bt_status();
		}
		else
		{
			bluetooth_status=2;
			value=fgetc(fp2);
			if(value!=EOF)
			{
				if(value=='1')
				{
					BT_ON_BUTTON_ACTIVE;
					bt_on_selected();
					bluetooth_ret=1;
				}
				else if(value=='0')
				{
					BT_OFF_BUTTON_ACTIVE;
					bt_off_selected();
					bluetooth_ret=0;
				}	
			}
			else
			{
				printf("bt_sw has nothing!\n");
				check_bt_status();
			}
			fclose(fp2);
		}
	}
	return bluetooth_ret;
}

int get_op_status()
{
	FILE *fp;
	char value;
	int op_ret=-1;
	if((fp=fopen(OJ6SH_WHEEL,"r"))==NULL)
	{
		optical_point_status=0;
		printf("oj6sh_wheel isn't exist!\n");
		CURSOR_BUTTON_ACTIVE;
		cursor_selected();
	}
	else
	{
		optical_point_status=1;
		fclose(fp);
		FILE *fp2;
		if((fp2=fopen(OJ6SH_WHEEL,"r+"))==NULL)
		{
			printf("oj6sh_wheel read only!\n");
		}
		else
		{
			optical_point_status=2;
			value=fgetc(fp2);
			if(value!=EOF)
			{
				if(value=='1')
				{	
					WHEEL_BUTTON_ACTIVE;
					wheel_selected();
					op_ret=1;
				}
				else
				{
					CURSOR_BUTTON_ACTIVE;
					cursor_selected();
					op_ret=0;
				}
			}
			else
			{
				printf("oj6sh_wheel has nothing!\n");
				cursor_selected();
			}			
		}
		fclose(fp2);
	}
	return op_ret;
}

//wireless opteration
void wlan_read_error(GtkWidget *widget, gpointer window)
{
  wlan_read_dialog = gtk_message_dialog_new(window,
            GTK_DIALOG_DESTROY_WITH_PARENT,
            GTK_MESSAGE_ERROR,
            GTK_BUTTONS_OK,
            _("Can't find the file:/proc/wlan_sw!"));
  gtk_window_set_title(GTK_WINDOW(wlan_read_dialog), _("Error"));
  gtk_dialog_run(GTK_DIALOG(wlan_read_dialog));
  gtk_widget_destroy(wlan_read_dialog);
}

void wlan_write_error(GtkWidget *widget, gpointer window)
{
  GtkWidget *dialog;
  wlan_write_dialog = gtk_message_dialog_new(window,
            GTK_DIALOG_DESTROY_WITH_PARENT,
            GTK_MESSAGE_ERROR,
            GTK_BUTTONS_OK,
            _("Read only file:/proc/wlan_sw!"));
  gtk_window_set_title(GTK_WINDOW(wlan_write_dialog), _("Error"));
  gtk_dialog_run(GTK_DIALOG(wlan_write_dialog));
  gtk_widget_destroy(wlan_write_dialog);
}

int get_wlan_status_value()
{
	FILE *fp;
	char value;
	int wlan_ret=-1;
	if((fp=fopen(WLAN_SW,"r"))==NULL)
	{
		wlan_status=0;
		printf("wlan_sw isn't exist!\n");
		check_wlan_status();
	}
	else
	{
		fclose(fp);
		FILE *fp2;
		if((fp2=fopen(WLAN_SW,"r+"))==NULL)
		{
			wlan_status=1;
			printf("wlan_sw read only!\n");
			check_wlan_status();
		}
		else
		{
			wlan_status=2;
			value=fgetc(fp2);
			if(value!=EOF)
			{
				if(value=='1')
				{
					wlan_on_selected();
					wlan_ret=1;
				}
				else if(value=='0')
				{
					wlan_off_selected();
					wlan_ret=0;
				}
		
			}
			else
			{
				printf("wlan_sw has nothing!\n");
				check_wlan_status();
			}	
			fclose(fp2);
		}
	}
	return wlan_ret;
}

void wlan_on(GtkWidget *widget,gpointer data)
{
	if(get_wlan_status_value() == 1)//to avoid acted more times when clicked once more times;
	{
		printf("wlan already on\n");
		return;
	}

	FILE *fp;
	char wlan_value='1';
	if(wlan_status==1)
	{
		wlan_write_error(GTK_WIDGET(wlan_write_dialog),wnd);
		gtk_button_enter(GTK_BUTTON(wlan_on_button));
		printf("can't write wlan_sw!\n");
	}
	else if(wlan_status==2)
	{
		if((fp=fopen(WLAN_SW,"r+"))==NULL)
		{
			printf("wlan_sw read only!\n");
		}
		else
		{
			fputc(wlan_value,fp);
			wlan_on_selected();
		}
		fclose(fp);
	}
	else if(wlan_status==0)
	{
		wlan_read_error(GTK_WIDGET(wlan_read_dialog),data);
		gtk_button_enter(GTK_BUTTON(wlan_on_button));
		printf("please find the wlan_sw!\n");
	}

}

void wlan_off(GtkWidget *widget,gpointer data)
{
	if(get_wlan_status_value() == 0)
	{
		printf("wlan already off!\n");
		return;
	}

	FILE *fp;
	wlan_value='0';
	if(wlan_status==1)
	{
		wlan_write_error(GTK_WIDGET(wlan_write_dialog),wnd);
		gtk_button_enter(GTK_BUTTON(wlan_off_button));
		printf("can't write wlan_sw!\n");
	}
	else if(wlan_status==2) 
	{
		if((fp=fopen(WLAN_SW,"r+"))==NULL)
		{
			printf("wlan_sw read only!\n");
		}
		else
		{
			fputc(wlan_value,fp);
			wlan_off_selected();
		}
		fclose(fp);
	}
	else if(wlan_status==0)
	{
		wlan_read_error(GTK_WIDGET(wlan_read_dialog),wnd);
		gtk_button_enter(GTK_BUTTON(wlan_off_button));
		printf("please find the wlan_sw!\n");
	}

}

//bluetooth operation
void bluetooth_read_error(GtkWidget *widget, gpointer window)
{
  bluetooth_read_dialog = gtk_message_dialog_new(window,
            GTK_DIALOG_DESTROY_WITH_PARENT,
            GTK_MESSAGE_ERROR,
            GTK_BUTTONS_OK,
            _("Can't find the file:/proc/bt_sw!"));
  gtk_window_set_title(GTK_WINDOW(bluetooth_read_dialog), _("Error"));
  gtk_dialog_run(GTK_DIALOG(bluetooth_read_dialog));
  gtk_widget_destroy(bluetooth_read_dialog);
}

void bluetooth_write_error(GtkWidget *widget, gpointer window)
{
  bluetooth_write_dialog = gtk_message_dialog_new(window,
            GTK_DIALOG_DESTROY_WITH_PARENT,
            GTK_MESSAGE_ERROR,
            GTK_BUTTONS_OK,
            _("Read only file:/proc/bt_sw!"));
  gtk_window_set_title(GTK_WINDOW(bluetooth_write_dialog), _("Error"));
  gtk_dialog_run(GTK_DIALOG(bluetooth_write_dialog));
  gtk_widget_destroy(bluetooth_write_dialog);
}

int get_bt_status_value()
{
	FILE *fp;
	char value;
	int bluetooth_ret=-1;
	if((fp=fopen(BT_SW,"r"))==NULL)
	{
		bluetooth_status=0;
		printf("bt_sw isn't exist!\n");
		check_bt_status();
	}
	else
	{
		fclose(fp);
		FILE *fp2;
		if((fp2=fopen(BT_SW,"r+"))==NULL)
		{
			bluetooth_status=1;
			printf("bt_sw read only!\n");
			check_bt_status();
		}
		else
		{
			bluetooth_status=2;
			value=fgetc(fp2);
			if(value!=EOF)
			{
				if(value=='1')
				{
					bluetooth_ret=1;
				}
				else if(value=='0')
				{
					bluetooth_ret=0;
				}	
			}
			else
			{
				printf("bt_sw has nothing!\n");
				check_bt_status();
			}
			fclose(fp2);
		}
	}
	return bluetooth_ret;
}
void bluetooth_on(GtkWidget *widget,gpointer data)
{
	if(get_bt_status_value() == 1)
	{
		printf("bluetooth already on!\n");
		return;
	}

	FILE *fp;
	bluetooth_value='1';
	if(bluetooth_status==1)
	{
		bluetooth_write_error(GTK_WIDGET(bluetooth_write_dialog),wnd);
		gtk_button_enter(GTK_BUTTON(bt_on_button));
		printf("can't write bt_sw");
	}
	else if(bluetooth_status==2)
	{
		if((fp=fopen(BT_SW,"r+"))==NULL)
		{
			printf("bt_sw read only!\n");
		}
		else
		{
			fputc(bluetooth_value,fp);
			bt_on_selected();
		}
		fclose(fp);
	}
	else if(bluetooth_status==0)
	{
		bluetooth_read_error(GTK_WIDGET(bluetooth_write_dialog),wnd);
		gtk_button_enter(GTK_BUTTON(bt_on_button));
		printf("please find the bt_sw!\n");
	}

}

void bluetooth_off(GtkWidget *widget,gpointer data)
{
	if(get_bt_status_value() == 0)
	{
		printf("bluetooth already off\n");
		return;
	}

	FILE *fp;
	bluetooth_value='0';
	if(bluetooth_status==1)
	{
		bluetooth_write_error(GTK_WIDGET(bluetooth_write_dialog),wnd);
		gtk_button_enter(GTK_BUTTON(bt_off_button));
		printf("can't write bt_sw!\n");
	}
	else if(bluetooth_status==2)
		{
			if((fp=fopen(BT_SW,"r+"))==NULL)
			{
				printf("bt_sw read only!\n");
			}
			else
			{
				fputc(bluetooth_value,fp);
				bt_off_selected();
			}
			fclose(fp);
		}
	else if(bluetooth_status==0)
	{
		bluetooth_read_error(GTK_WIDGET(bluetooth_write_dialog),wnd);
		gtk_button_enter(GTK_BUTTON(bt_off_button));
		printf("please find the bt_sw!\n");
	}

}

//optical operation
void optical_point_read_error(GtkWidget *widget, gpointer window)
{
  optical_point_read_dialog = gtk_message_dialog_new(window,
            GTK_DIALOG_DESTROY_WITH_PARENT,
            GTK_MESSAGE_ERROR,
            GTK_BUTTONS_OK,
            _("Can't find the file:/proc/oj6sh_wheel!"));
  gtk_window_set_title(GTK_WINDOW(optical_point_read_dialog), _("Error"));
  gtk_dialog_run(GTK_DIALOG(optical_point_read_dialog));
  gtk_widget_destroy(optical_point_read_dialog);
}

void optical_point_write_error(GtkWidget *widget, gpointer window)
{
  optical_point_write_dialog = gtk_message_dialog_new(window,
            GTK_DIALOG_DESTROY_WITH_PARENT,
            GTK_MESSAGE_ERROR,
            GTK_BUTTONS_OK,
            _("Read only file:/proc/oj6sh_wheel!"));
  gtk_window_set_title(GTK_WINDOW(optical_point_write_dialog), _("Error"));
  gtk_dialog_run(GTK_DIALOG(optical_point_write_dialog));
  gtk_widget_destroy(optical_point_write_dialog);
}

int get_op_status_value()
{
	FILE *fp;
	char value;
	int op_ret=-1;
	if((fp=fopen(OJ6SH_WHEEL,"r"))==NULL)
	{
		optical_point_status=0;
		printf("oj6sh_wheel isn't exist!\n");
		CURSOR_BUTTON_ACTIVE;
		cursor_selected();
	}
	else
	{
		optical_point_status=1;
		fclose(fp);
		FILE *fp2;
		if((fp2=fopen(OJ6SH_WHEEL,"r+"))==NULL)
		{
			printf("oj6sh_wheel read only!\n");
		}
		else
		{
			optical_point_status=2;
			value=fgetc(fp2);
			if(value!=EOF)
			{
				if(value=='1')
				{	
					op_ret=1;
				}
				else
				{
					op_ret=0;
				}
			}
			else
			{
				printf("oj6sh_wheel has nothing!\n");
				cursor_selected();
			}			
		}
		fclose(fp2);
	}
	return op_ret;
}

void cursor_mode(GtkWidget *widget,gpointer data)
{
	if(get_op_status_value() == 0)
	{
		printf("cursor mode already!\n");
		return;
	}

	FILE *fp;
	optical_point_value='0';
	if(optical_point_status==1)
	{
		optical_point_write_error(GTK_WIDGET(optical_point_write_dialog),wnd);
		gtk_button_enter(GTK_BUTTON(cursor_button));
		printf("can't write oj6sh_wheel!\n");
	}
	else if(optical_point_status==2)
	{
		if((fp=fopen(OJ6SH_WHEEL,"r+"))==NULL)
		{
			printf("oj6sh_wheel read only!\n");
		}
		else
		{
			fputc(optical_point_value,fp);
			cursor_selected();
		}
		fclose(fp);
	}
	else if(optical_point_status==0)
	{
		optical_point_read_error(GTK_WIDGET(optical_point_read_dialog),wnd);
		gtk_button_enter(GTK_BUTTON(cursor_button));
		printf("please find oj6sh_wheel!\n");
	}
	
}

void wheel_mode(GtkWidget *widget,gpointer data)
{
	if(get_op_status_value() == 1)
	{
		printf("wheel mode already!\n");
		return;
	}
	
	FILE *fp;
	optical_point_value='1';
	if(optical_point_status==1)
	{
		optical_point_write_error(GTK_WIDGET(optical_point_write_dialog),wnd);
		gtk_button_enter(GTK_BUTTON(wheel_button));
		printf("can't write oj6sh_wheel!\n");
	}
	else if(optical_point_status==2)
	{
		if((fp=fopen(OJ6SH_WHEEL,"r+"))==NULL)
		{
			printf("oj6sh_wheel read only!\n");
		}
		else
		{
			fputc(optical_point_value,fp);
			wheel_selected();
		}
		fclose(fp);
	}
	else if(optical_point_status==0)
	{	
		optical_point_read_error(GTK_WIDGET(optical_point_read_dialog),wnd);
		gtk_button_enter(GTK_BUTTON(wheel_button));
		printf("please find oj6sh_wheel!\n");
	}	
}

void intialization()
{
	if(wlan_status==2)
	{
		WLAN_OFF_BUTTON_ACTIVE;
		wlan_off_selected();
	}		
	wlan_off(wlan_on_button,optical_point_value);
	if(bluetooth_status==2)
	{
		BT_OFF_BUTTON_ACTIVE;
		bt_off_selected();
	}
	bluetooth_off(bt_on_button,bluetooth_value);
	if(optical_point_status==2)
	{
		CURSOR_BUTTON_ACTIVE;
		cursor_selected();
	}
	cursor_mode(cursor_button,optical_point_value);
}

//about icon on top left corner;	
GdkPixbuf *create_pixbuf(const gchar * filename)
{
   GdkPixbuf *pixbuf;
   GError *error = NULL;

   pixbuf = gdk_pixbuf_new_from_file(filename, &error);

   if(!pixbuf) 
   {
      fprintf(stderr, "%s\n", error->message);
      g_error_free(error);
   }
   return pixbuf;
}

//main loop

int main(int argc,char* argv[])
{
	gtk_init(&argc,&argv);

	setlocale(LC_ALL, "");
	bindtextdomain(GETTEXT_PACKAGE, "/usr/share/locale");
	textdomain(GETTEXT_PACKAGE);
	
	check_language();	

	wnd=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(wnd),_("Device Setup Utility"));
	gtk_window_set_position(GTK_WINDOW(wnd),GTK_WIN_POS_CENTER);
	gtk_window_set_default_size(GTK_WINDOW(wnd),280,210);
	gtk_window_set_resizable(GTK_WINDOW(wnd),FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(wnd),15);

//add icon on top left corner;	
	wnd_icon_pixbuf = create_pixbuf(ICON);
	if(wnd_icon_pixbuf)
    {
      gtk_window_set_icon(GTK_WINDOW(wnd), wnd_icon_pixbuf);
      gdk_pixbuf_unref(wnd_icon_pixbuf);
    }

	fixed=gtk_fixed_new();
	gtk_widget_show(fixed);
	gtk_container_add(GTK_CONTAINER(wnd),fixed);
	

//about wlan_on_button;

	wlan_on_button = gtk_radio_button_new (NULL);
  	gtk_widget_show (wlan_on_button);
  	gtk_fixed_put (GTK_FIXED (fixed), wlan_on_button, 200, 8);
  	gtk_widget_set_size_request (wlan_on_button, 136, 72);
  	gtk_radio_button_set_group (GTK_RADIO_BUTTON (wlan_on_button), wlan_group);
  	wlan_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (wlan_on_button));
  	gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (wlan_on_button), FALSE);
	GTK_WIDGET_UNSET_FLAGS(wlan_on_button, GTK_CAN_FOCUS);

	wlan_on_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  	gtk_widget_show (wlan_on_alignment);
  	gtk_container_add (GTK_CONTAINER (wlan_on_button), wlan_on_alignment);
  	gtk_widget_set_size_request (wlan_on_alignment, 130, 40);

  	wlan_on_hbox = gtk_hbox_new (FALSE, 2);
  	gtk_widget_show (wlan_on_hbox);
  	gtk_container_add (GTK_CONTAINER (wlan_on_alignment), wlan_on_hbox);
  	gtk_widget_set_size_request (wlan_on_hbox, 120, 60);

  	wlan_on_image = gtk_image_new_from_stock ("gtk-yes", GTK_ICON_SIZE_BUTTON);
  	gtk_box_pack_start (GTK_BOX (wlan_on_hbox), wlan_on_image, FALSE, FALSE, 0);
  	gtk_widget_set_size_request (wlan_on_image, 24, 24);

  	wlan_on_label = gtk_label_new_with_mnemonic (_("ON"));
  	gtk_widget_show (wlan_on_label);
  	gtk_box_pack_start (GTK_BOX (wlan_on_hbox), wlan_on_label, FALSE, FALSE, 0);
  	gtk_widget_set_size_request (wlan_on_label, 70, 40);
  	gtk_label_set_justify (GTK_LABEL (wlan_on_label), GTK_JUSTIFY_CENTER);
	
	g_signal_connect(GTK_OBJECT(wlan_on_button),"pressed",G_CALLBACK(wlan_on),NULL);

//about wlan_off_button;

	wlan_off_button = gtk_radio_button_new (NULL);
  	gtk_widget_show (wlan_off_button);
  	gtk_fixed_put (GTK_FIXED (fixed), wlan_off_button, 344, 8);
  	gtk_widget_set_size_request (wlan_off_button, 136, 72);
  	gtk_radio_button_set_group (GTK_RADIO_BUTTON (wlan_off_button), wlan_group);
  	wlan_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (wlan_off_button));
  	gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (wlan_off_button), FALSE);
	GTK_WIDGET_UNSET_FLAGS(wlan_off_button, GTK_CAN_FOCUS);

  	wlan_off_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  	gtk_widget_show (wlan_off_alignment);
  	gtk_container_add (GTK_CONTAINER (wlan_off_button), wlan_off_alignment);
  	gtk_widget_set_size_request (wlan_off_alignment, 120, 60);
  	gtk_alignment_set_padding (GTK_ALIGNMENT (wlan_off_alignment), 0, 0, 0, 3);

  	wlan_off_hbox = gtk_hbox_new (FALSE, 2);
  	gtk_widget_show (wlan_off_hbox);
  	gtk_container_add (GTK_CONTAINER (wlan_off_alignment), wlan_off_hbox);
  	gtk_widget_set_size_request (wlan_off_hbox, 120, 60);

  	wlan_off_image = gtk_image_new_from_stock ("gtk-yes", GTK_ICON_SIZE_BUTTON);
  	gtk_box_pack_start (GTK_BOX (wlan_off_hbox), wlan_off_image, FALSE, FALSE, 0);

  	wlan_off_label = gtk_label_new_with_mnemonic (_("OFF"));
  	gtk_widget_show (wlan_off_label);
  	gtk_box_pack_start (GTK_BOX (wlan_off_hbox), wlan_off_label, FALSE, FALSE, 0);
  	gtk_widget_set_size_request (wlan_off_label, 70, 40);
  	gtk_label_set_justify (GTK_LABEL (wlan_off_label), GTK_JUSTIFY_CENTER);
	
	g_signal_connect(GTK_OBJECT(wlan_off_button),"pressed",G_CALLBACK(wlan_off),NULL);

//about bt_on_button;

	bt_on_button = gtk_radio_button_new (NULL);
  	gtk_widget_show (bt_on_button);
  	gtk_fixed_put (GTK_FIXED (fixed),bt_on_button, 200, 88);
  	gtk_widget_set_size_request (bt_on_button, 136, 72);
  	gtk_radio_button_set_group (GTK_RADIO_BUTTON (bt_on_button), bt_group);
  	bt_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (bt_on_button));
  	gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (bt_on_button), FALSE);
	GTK_WIDGET_UNSET_FLAGS(bt_on_button, GTK_CAN_FOCUS);

	bt_on_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  	gtk_widget_show (bt_on_alignment);
  	gtk_container_add (GTK_CONTAINER (bt_on_button), bt_on_alignment);
  	gtk_widget_set_size_request (bt_on_alignment, 130, 40);

  	bt_on_hbox = gtk_hbox_new (FALSE, 2);
  	gtk_widget_show (bt_on_hbox);
  	gtk_container_add (GTK_CONTAINER (bt_on_alignment), bt_on_hbox);
  	gtk_widget_set_size_request (bt_on_hbox, 120, 40);

  	bt_on_image = gtk_image_new_from_stock ("gtk-yes", GTK_ICON_SIZE_BUTTON);
  	gtk_widget_show (bt_on_image);
  	gtk_box_pack_start (GTK_BOX (bt_on_hbox), bt_on_image, FALSE, FALSE, 0);
  	gtk_widget_set_size_request (bt_on_image, 24, 24);

  	bt_on_label = gtk_label_new_with_mnemonic (_("ON"));
  	gtk_widget_show (bt_on_label);
  	gtk_box_pack_start (GTK_BOX (bt_on_hbox), bt_on_label, FALSE, FALSE, 0);
  	gtk_widget_set_size_request (bt_on_label, 70, 40);
  	gtk_label_set_justify (GTK_LABEL (bt_on_label), GTK_JUSTIFY_CENTER);
	
	g_signal_connect(GTK_OBJECT(bt_on_button),"pressed",G_CALLBACK(bluetooth_on),NULL);

//about bt_off_button;

	bt_off_button = gtk_radio_button_new (NULL);
  	gtk_widget_show (bt_off_button);
  	gtk_fixed_put (GTK_FIXED (fixed), bt_off_button, 344, 88);
  	gtk_widget_set_size_request (bt_off_button, 136, 72);
  	gtk_radio_button_set_group (GTK_RADIO_BUTTON (bt_off_button), bt_group);
  	bt_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (bt_off_button));
  	gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (bt_off_button), FALSE);
	GTK_WIDGET_UNSET_FLAGS(bt_off_button, GTK_CAN_FOCUS);
	
  	bt_off_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  	gtk_widget_show (bt_off_alignment);
  	gtk_container_add (GTK_CONTAINER (bt_off_button), bt_off_alignment);
  	gtk_widget_set_size_request (bt_off_alignment, 130, 40);
  	gtk_alignment_set_padding (GTK_ALIGNMENT (bt_off_alignment), 0, 0, 0, 3);

  	bt_off_hbox = gtk_hbox_new (FALSE, 2);
  	gtk_widget_show (bt_off_hbox);
  	gtk_container_add (GTK_CONTAINER (bt_off_alignment), bt_off_hbox);
  	gtk_widget_set_size_request (bt_off_hbox, 120, 40);

  	bt_off_image = gtk_image_new_from_stock ("gtk-yes", GTK_ICON_SIZE_BUTTON);
  	gtk_box_pack_start (GTK_BOX (bt_off_hbox), bt_off_image, FALSE, FALSE, 0);
  	gtk_widget_set_size_request (bt_off_image, 24, 24);

  	bt_off_label = gtk_label_new_with_mnemonic (_("OFF"));
  	gtk_widget_show (bt_off_label);
  	gtk_box_pack_start (GTK_BOX (bt_off_hbox), bt_off_label, FALSE, FALSE, 0);
  	gtk_widget_set_size_request (bt_off_label, 70, 40);
  	gtk_label_set_justify (GTK_LABEL (bt_off_label), GTK_JUSTIFY_CENTER);
	
	g_signal_connect(GTK_OBJECT(bt_off_button),"pressed",G_CALLBACK(bluetooth_off),NULL);

//about cursor_button;

	cursor_button = gtk_radio_button_new (NULL);
  	gtk_widget_show (cursor_button);
  	gtk_fixed_put (GTK_FIXED (fixed), cursor_button, 200, 168);
  	gtk_widget_set_size_request (cursor_button, 136, 72);
  	gtk_radio_button_set_group (GTK_RADIO_BUTTON (cursor_button), op_group);
  	op_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (cursor_button));
  	gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (cursor_button), FALSE);
	GTK_WIDGET_UNSET_FLAGS(cursor_button, GTK_CAN_FOCUS);

  	cursor_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  	gtk_widget_show (cursor_alignment);
  	gtk_container_add (GTK_CONTAINER (cursor_button), cursor_alignment);
  	gtk_widget_set_size_request (cursor_alignment, 134, 40);

  	cursor_hbox = gtk_hbox_new (FALSE, 2);
  	gtk_widget_show (cursor_hbox);
  	gtk_container_add (GTK_CONTAINER (cursor_alignment), cursor_hbox);
  	gtk_widget_set_size_request (cursor_hbox, 130, 60);

  	cursor_image = gtk_image_new_from_stock ("gtk-yes", GTK_ICON_SIZE_BUTTON);
  	gtk_box_pack_start (GTK_BOX (cursor_hbox), cursor_image, FALSE, FALSE, 0);

  	cursor_label = gtk_label_new_with_mnemonic (_("Cursor Mode"));
  	gtk_widget_show (cursor_label);
  	gtk_box_pack_start (GTK_BOX (cursor_hbox), cursor_label, FALSE, FALSE, 0);
  	gtk_widget_set_size_request (cursor_label, 87, 60);
  	gtk_label_set_justify (GTK_LABEL (cursor_label), GTK_JUSTIFY_CENTER);
	
	g_signal_connect(GTK_OBJECT(cursor_button),"pressed",G_CALLBACK(cursor_mode),NULL);


//about wheel_button;

	wheel_button = gtk_radio_button_new (NULL);
  	gtk_widget_show (wheel_button);
  	gtk_fixed_put (GTK_FIXED (fixed), wheel_button, 344, 168);
  	gtk_widget_set_size_request (wheel_button, 136, 72);
  	gtk_radio_button_set_group (GTK_RADIO_BUTTON (wheel_button), op_group);
  	op_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (wheel_button));
  	gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (wheel_button), FALSE);
	GTK_WIDGET_UNSET_FLAGS(wheel_button, GTK_CAN_FOCUS);

  	wheel_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  	gtk_widget_show (wheel_alignment);
  	gtk_container_add (GTK_CONTAINER (wheel_button), wheel_alignment);
  	gtk_widget_set_size_request (wheel_alignment, 130, 40);

  	cursor_hbox = gtk_hbox_new (FALSE, 2);
  	gtk_widget_show (cursor_hbox);
  	gtk_container_add (GTK_CONTAINER (wheel_alignment), cursor_hbox);
  	gtk_widget_set_size_request (cursor_hbox, 120, 60);

  	wheel_image = gtk_image_new_from_stock ("gtk-yes", GTK_ICON_SIZE_BUTTON);
  	gtk_box_pack_start (GTK_BOX (cursor_hbox), wheel_image, FALSE, FALSE, 0);
  	gtk_widget_set_size_request (wheel_image, 24, 24);

  	wheel_label = gtk_label_new_with_mnemonic (_("Wheel Mode"));
  	gtk_widget_show (wheel_label);
  	gtk_box_pack_start (GTK_BOX (cursor_hbox), wheel_label, FALSE, FALSE, 0);
  	gtk_widget_set_size_request (wheel_label, 86, 60);
	gtk_label_set_justify (GTK_LABEL (wheel_label), GTK_JUSTIFY_CENTER);
	
	g_signal_connect(GTK_OBJECT(wheel_button),"pressed",G_CALLBACK(wheel_mode),NULL);

//set default value;	
	initialize_button = gtk_button_new_with_mnemonic (_("Default"));
	gtk_widget_show (initialize_button);
	gtk_fixed_put (GTK_FIXED (fixed), initialize_button, 2, 270);
	gtk_widget_set_size_request (initialize_button, 138, 32);
	GTK_WIDGET_UNSET_FLAGS(initialize_button, GTK_CAN_FOCUS);
	g_signal_connect(GTK_OBJECT(initialize_button),"clicked",G_CALLBACK(intialization),NULL);

//close button;
	close_button = gtk_button_new_with_mnemonic (_("Close(_C)"));
	gtk_widget_show (close_button);
	GTK_WIDGET_SET_FLAGS (close_button, GTK_CAN_DEFAULT);
	gtk_widget_grab_focus(close_button);//set the focus on this button;

	gtk_fixed_put (GTK_FIXED (fixed), close_button, 338, 270);
	gtk_widget_set_size_request (close_button, 138, 32);

	g_signal_connect(GTK_OBJECT(close_button),"clicked",G_CALLBACK(release_resource),NULL);
	
	wlan_label=gtk_label_new(_("Wireless LAN"));
	gtk_widget_show(wlan_label);
	gtk_fixed_put(GTK_FIXED(fixed),wlan_label,10,40);
	gtk_widget_set_size_request(wlan_label,190,17);
	gtk_misc_set_alignment(GTK_MISC(wlan_label),0.5,0.5);
	
	bluetooth_label=gtk_label_new(_("Bluetooth"));
	gtk_widget_show(bluetooth_label);
	gtk_fixed_put(GTK_FIXED(fixed),bluetooth_label,10,120);
	gtk_widget_set_size_request(bluetooth_label,190,17);
	gtk_misc_set_alignment(GTK_MISC(bluetooth_label),0.5,0.5);
	
	op_label=gtk_label_new(_("Optical Point"));
	gtk_widget_show(op_label);
	gtk_fixed_put(GTK_FIXED(fixed),op_label,3,192);
	gtk_widget_set_size_request(op_label,190,17);
	gtk_misc_set_alignment(GTK_MISC(op_label),0.5,0.5);

	g_signal_connect(G_OBJECT(wnd),"delete_event",G_CALLBACK(release_resource),NULL);
	
	get_wlan_status();
	get_bt_status();
	get_op_status();

	gtk_widget_show(wnd);
	gtk_main();

	return 0;

}
