/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */

#include <linux/errno.h>
#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/delay.h>
#include <asm/io.h>
#include <mach/hardware.h>
#include <mach/clock.h>
#include <mach/gpio.h>

#include "iomux.h"

/*!
 * @file mach-mx51/mx51_3stack_gpio.c
 *
 * @brief This file contains all the GPIO setup functions for the board.
 *
 * @ingroup GPIO
 */
#define ATA_PAD_CONFIG (PAD_CTL_DRV_HIGH | PAD_CTL_DRV_VOT_HIGH)

static struct mxc_iomux_pin_cfg __initdata mxc_iomux_pins[] = {
	/* CSI0 */
	{
	MX51_PIN_CSI1_D8, IOMUX_CONFIG_ALT3,
	PAD_CTL_PKE_ENABLE,
	MUX_IN_GPIO3_IPP_IND_G_IN_12_SELECT_INPUT,
	INPUT_CTL_PATH1,
	},
	{
	MX51_PIN_CSI1_D9, IOMUX_CONFIG_ALT3,
	PAD_CTL_PKE_ENABLE,
	},
	{
	 MX51_PIN_CSI1_D10, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE,
	 },
	{
	 MX51_PIN_CSI1_D11, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE,
	 },
	{
	 MX51_PIN_CSI1_D12, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE,
	 },
	{
	 MX51_PIN_CSI1_D13, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE,
	 },
	{
	 MX51_PIN_CSI1_D14, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE,
	 },
	{
	 MX51_PIN_CSI1_D15, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE,
	 },
	{
	 MX51_PIN_CSI1_D16, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE,
	 },
	{
	 MX51_PIN_CSI1_D17, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE,
	 },
	{
	 MX51_PIN_CSI1_D18, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE,
	 },
	{
	 MX51_PIN_CSI1_D19, IOMUX_CONFIG_ALT0, PAD_CTL_HYS_NONE,
	 },
	{
	 MX51_PIN_CSI1_VSYNC, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_NONE | PAD_CTL_SRE_SLOW),
	 },
	{
	 MX51_PIN_CSI1_HSYNC, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_NONE | PAD_CTL_SRE_SLOW),
	 },
	{
	MX51_PIN_EIM_A26, IOMUX_CONFIG_ALT5 | IOMUX_CONFIG_SION,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_100K_PU | PAD_CTL_PUE_PULL),
	 MUX_IN_HSC_MIPI_MIX_IPP_IND_SENS2_DATA_EN_SELECT_INPUT,
	 INPUT_CTL_PATH0,
	 },
	{			/* SPI1 */
	 MX51_PIN_CSPI1_MISO, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_DRV_HIGH |
				  PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_CSPI1_MOSI, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_DRV_HIGH |
				  PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_CSPI1_RDY, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_DRV_HIGH |
				  PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_CSPI1_SCLK, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_DRV_HIGH |
				  PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_CSPI1_SS0, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_DRV_HIGH |
				  PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_CSPI1_SS1, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_DRV_HIGH |
				  PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_OWIRE_LINE, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE |
		 PAD_CTL_ODE_OPENDRAIN_ENABLE | PAD_CTL_DRV_HIGH |
		 PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_DISP2_DAT15, IOMUX_CONFIG_ALT5,
	 },
	{
	 MX51_PIN_DI_GP2, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_DI_GP3, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_KEY_COL0, IOMUX_CONFIG_ALT0,
	},
	{
	 MX51_PIN_KEY_COL1, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_KEY_COL2, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_KEY_COL3, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_KEY_COL4, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_KEY_COL5, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_KEY_ROW0, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_KEY_ROW1, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_KEY_ROW2, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_KEY_ROW3, IOMUX_CONFIG_ALT0,
	 },
	{			/* AUD3_TXD */
	 MX51_PIN_AUD3_BB_TXD, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
	    PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_100K_PU |
	    PAD_CTL_HYS_NONE | PAD_CTL_DDR_INPUT_CMOS | PAD_CTL_DRV_VOT_LOW),
	 },
	{			/* AUD3_RXD */
	 MX51_PIN_AUD3_BB_RXD, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
	    PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_100K_PU |
	    PAD_CTL_HYS_NONE | PAD_CTL_DDR_INPUT_CMOS | PAD_CTL_DRV_VOT_LOW),
	 },
	{			/* AUD3_CLK */
	 MX51_PIN_AUD3_BB_CK, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
	    PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_100K_PU |
	    PAD_CTL_HYS_NONE | PAD_CTL_DDR_INPUT_CMOS | PAD_CTL_DRV_VOT_LOW),
	 },
	{			/* AUD3_FS */
	 MX51_PIN_AUD3_BB_FS, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH |
	    PAD_CTL_ODE_OPENDRAIN_NONE | PAD_CTL_100K_PU |
	    PAD_CTL_HYS_NONE | PAD_CTL_DDR_INPUT_CMOS | PAD_CTL_DRV_VOT_LOW),
	 },
	{
	 MX51_PIN_EIM_D16, IOMUX_CONFIG_ALT1,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
			  PAD_CTL_PKE_ENABLE | PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_EIM_A27, IOMUX_CONFIG_ALT2,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
	  PAD_CTL_PUE_KEEPER | PAD_CTL_PKE_ENABLE | PAD_CTL_HYS_ENABLE),
	 },
	{
	MX51_PIN_EIM_EB2, IOMUX_CONFIG_ALT1,
	PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL | PAD_CTL_100K_PD,
	},
	{
	 MX51_PIN_EIM_DTACK, IOMUX_CONFIG_GPIO,
	 (PAD_CTL_PKE_ENABLE | PAD_CTL_100K_PU),
	 },
	{
	 MX51_PIN_EIM_CRE, IOMUX_CONFIG_GPIO,
	 },
	{
	 MX51_PIN_NANDF_CS0, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_NANDF_CS1, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_NANDF_CS2, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_NANDF_CS3, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_NANDF_CS4, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_NANDF_CS5, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_NANDF_CS6, IOMUX_CONFIG_ALT0,
	 },
	{
	 MX51_PIN_NANDF_CS7, IOMUX_CONFIG_ALT0,
	 },
	{ /* TO2 */
	MX51_PIN_GPIO_NAND, IOMUX_CONFIG_ALT0,
	},
	{ /* TO1 */
	MX51_PIN_NANDF_RB5, IOMUX_CONFIG_ALT0,
	},
	{
	 MX51_PIN_DI_GP4, IOMUX_CONFIG_ALT2,
	 },
	{
	 MX51_PIN_DISPB2_SER_DIN, IOMUX_CONFIG_GPIO,
	 0,
	 MUX_IN_GPIO3_IPP_IND_G_IN_5_SELECT_INPUT,
	 INPUT_CTL_PATH1,
	 },
	{
	 MX51_PIN_DISPB2_SER_RS, IOMUX_CONFIG_GPIO,
	 },
	{ /* TO2 */
	MX51_PIN_DI1_D1_CS, IOMUX_CONFIG_ALT4,
	},
	{ /* TO2 */
	MX51_PIN_DI1_D0_CS, IOMUX_CONFIG_ALT1,
	},
	{ /* TO2 */
	MX51_PIN_DI1_PIN11, IOMUX_CONFIG_ALT1,
	},
	{ /* TO2 */
	MX51_PIN_DI1_PIN12, IOMUX_CONFIG_ALT1,
	},
	{ /* TO2 */
	MX51_PIN_DI1_PIN13, IOMUX_CONFIG_ALT1,
	},
	{
	 MX51_PIN_I2C1_CLK, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
	 0x1E4,
	 },
	{
	 MX51_PIN_I2C1_DAT, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
	 0x1E4,
	 },
	{
	 MX51_PIN_GPIO1_6, IOMUX_CONFIG_GPIO,
	 },
	{
	 MX51_PIN_GPIO1_7, IOMUX_CONFIG_ALT2,
	 (PAD_CTL_DRV_HIGH | PAD_CTL_PUE_PULL |
			 PAD_CTL_100K_PU | PAD_CTL_PKE_ENABLE |
			 PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_GPIO1_2, IOMUX_CONFIG_ALT2 | IOMUX_CONFIG_SION,
	 (PAD_CTL_SRE_FAST | PAD_CTL_ODE_OPENDRAIN_ENABLE | PAD_CTL_DRV_HIGH |
	  PAD_CTL_100K_PU | PAD_CTL_HYS_ENABLE),
	 MUX_IN_I2C2_IPP_SCL_IN_SELECT_INPUT, INPUT_CTL_PATH3,
	 },
	{
	 MX51_PIN_GPIO1_3, IOMUX_CONFIG_ALT2 | IOMUX_CONFIG_SION,
	 (PAD_CTL_SRE_FAST | PAD_CTL_ODE_OPENDRAIN_ENABLE | PAD_CTL_DRV_HIGH |
	  PAD_CTL_100K_PU | PAD_CTL_HYS_ENABLE),
	 MUX_IN_I2C2_IPP_SDA_IN_SELECT_INPUT, INPUT_CTL_PATH3,
	 },
	{
	 MX51_PIN_USBH1_STP, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_PKE_ENABLE | PAD_CTL_HYS_ENABLE),
	 },
	{			/* USBH1_CLK */
	 MX51_PIN_USBH1_CLK, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_PKE_ENABLE | PAD_CTL_HYS_ENABLE | PAD_CTL_DDR_INPUT_CMOS),
	 },
	{			/* USBH1_DIR */
	 MX51_PIN_USBH1_DIR, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_PKE_ENABLE | PAD_CTL_HYS_ENABLE | PAD_CTL_DDR_INPUT_CMOS),
	 },
	{			/* USBH1_NXT */
	 MX51_PIN_USBH1_NXT, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_PKE_ENABLE | PAD_CTL_HYS_ENABLE | PAD_CTL_DDR_INPUT_CMOS),
	 },
	{			/* USBH1_DATA0 */
	 MX51_PIN_USBH1_DATA0, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
	  PAD_CTL_PUE_KEEPER | PAD_CTL_PKE_ENABLE | PAD_CTL_HYS_ENABLE),
	 },
	{			/* USBH1_DATA1 */
	 MX51_PIN_USBH1_DATA1, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
	  PAD_CTL_PUE_KEEPER | PAD_CTL_PKE_ENABLE | PAD_CTL_HYS_ENABLE),
	 },
	{			/* USBH1_DATA2 */
	 MX51_PIN_USBH1_DATA2, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
	  PAD_CTL_PUE_KEEPER | PAD_CTL_PKE_ENABLE | PAD_CTL_HYS_ENABLE),
	 },
	{			/* USBH1_DATA3 */
	 MX51_PIN_USBH1_DATA3, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
	  PAD_CTL_PUE_KEEPER | PAD_CTL_PKE_ENABLE | PAD_CTL_HYS_ENABLE),
	 },
	{			/* USBH1_DATA4 */
	 MX51_PIN_USBH1_DATA4, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
	  PAD_CTL_PUE_KEEPER | PAD_CTL_PKE_ENABLE | PAD_CTL_HYS_ENABLE),
	 },
	{			/* USBH1_DATA5 */
	 MX51_PIN_USBH1_DATA5, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
	  PAD_CTL_PUE_KEEPER | PAD_CTL_PKE_ENABLE | PAD_CTL_HYS_ENABLE),
	 },
	{			/* USBH1_DATA6 */
	 MX51_PIN_USBH1_DATA6, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
	  PAD_CTL_PUE_KEEPER | PAD_CTL_PKE_ENABLE | PAD_CTL_HYS_ENABLE),
	 },
	{			/* USBH1_DATA7 */
	 MX51_PIN_USBH1_DATA7, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_100K_PU |
	  PAD_CTL_PUE_KEEPER | PAD_CTL_PKE_ENABLE | PAD_CTL_HYS_ENABLE),
	 },
	 {			/* USB1_OC */
	 MX51_PIN_GPIO1_9, IOMUX_CONFIG_ALT1,
	 (PAD_CTL_SRE_SLOW | PAD_CTL_DRV_LOW | PAD_CTL_ODE_OPENDRAIN_NONE |
			  PAD_CTL_PUE_KEEPER | PAD_CTL_PKE_ENABLE |
			  PAD_CTL_HYS_ENABLE),
	 },
	{			/* USB1_PWR */
	 MX51_PIN_GPIO1_8, IOMUX_CONFIG_ALT1,
	 (PAD_CTL_SRE_FAST | PAD_CTL_DRV_HIGH | PAD_CTL_ODE_OPENDRAIN_NONE |
			  PAD_CTL_PKE_NONE | PAD_CTL_HYS_ENABLE),
	 },
	{
	 MX51_PIN_SD1_CMD, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
	 (PAD_CTL_DRV_MAX | PAD_CTL_22K_PU | PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_SD1_CLK, IOMUX_CONFIG_ALT0 | IOMUX_CONFIG_SION,
	 (PAD_CTL_DRV_MAX | PAD_CTL_22K_PU | PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_SD1_DATA0, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_MAX | PAD_CTL_22K_PU | PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_SD1_DATA1, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_MAX | PAD_CTL_22K_PU | PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_SD1_DATA2, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_MAX | PAD_CTL_22K_PU | PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_SD1_DATA3, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_DRV_MAX | PAD_CTL_22K_PU | PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_GPIO1_0, IOMUX_CONFIG_GPIO | IOMUX_CONFIG_SION,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_100K_PU),
	 },
	{
	 MX51_PIN_GPIO1_1, IOMUX_CONFIG_GPIO | IOMUX_CONFIG_SION,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_100K_PU),
	 },
	{
	 MX51_PIN_UART1_RXD, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	  PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST),
	 MUX_IN_UART1_IPP_UART_RXD_MUX_SELECT_INPUT,
	 INPUT_CTL_PATH0,
	 },
	{
	 MX51_PIN_UART1_TXD, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	  PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_UART1_RTS, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	  PAD_CTL_DRV_HIGH),
	 MUX_IN_UART1_IPP_UART_RTS_B_SELECT_INPUT,
	 INPUT_CTL_PATH0,
	 },
	{
	 MX51_PIN_UART1_CTS, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_ENABLE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	  PAD_CTL_DRV_HIGH),
	 },
	{
	 MX51_PIN_UART2_RXD, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	  PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST),
	 MUX_IN_UART2_IPP_UART_RXD_MUX_SELECT_INPUT,
	 INPUT_CTL_PATH2,
	 },
	{
	 MX51_PIN_UART2_TXD, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_PULL |
	  PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_EIM_D26, IOMUX_CONFIG_ALT4,
	 (PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST),
	 MUX_IN_UART2_IPP_UART_RTS_B_SELECT_INPUT,
	 INPUT_CTL_PATH3,
	 },
	{
	 MX51_PIN_EIM_D25, IOMUX_CONFIG_ALT4,
	 (PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_UART3_RXD, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST),
	 MUX_IN_UART3_IPP_UART_RXD_MUX_SELECT_INPUT,
	 INPUT_CTL_PATH0,
	 },
	{
	 MX51_PIN_UART3_TXD, IOMUX_CONFIG_ALT0,
	 (PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST),
	 },
	{
	 MX51_PIN_EIM_D27, IOMUX_CONFIG_ALT3,
	 (PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST),
	 MUX_IN_UART3_IPP_UART_RTS_B_SELECT_INPUT,
	 INPUT_CTL_PATH2,
	 },
	{
	 MX51_PIN_EIM_D24, IOMUX_CONFIG_ALT3,
	 (PAD_CTL_HYS_NONE | PAD_CTL_PKE_ENABLE | PAD_CTL_PUE_KEEPER |
	  PAD_CTL_DRV_HIGH | PAD_CTL_SRE_FAST),
	 },
};

void __init mx51_3stack_io_init(void)
{
	int i;

	for (i = 0; i < ARRAY_SIZE(mxc_iomux_pins); i++) {
		mxc_request_iomux(mxc_iomux_pins[i].pin,
				  mxc_iomux_pins[i].mux_mode);
		if (mxc_iomux_pins[i].pad_cfg)
			mxc_iomux_set_pad(mxc_iomux_pins[i].pin,
					  mxc_iomux_pins[i].pad_cfg);
		if (mxc_iomux_pins[i].in_select)
			mxc_iomux_set_input(mxc_iomux_pins[i].in_select,
					    mxc_iomux_pins[i].in_mode);
	}

	/* Camera low power */
	mxc_set_gpio_direction(MX51_PIN_CSI1_D8, 0);
	mxc_set_gpio_dataout(MX51_PIN_CSI1_D8, 0);
	mxc_set_gpio_direction(MX51_PIN_EIM_EB2, 0);    /* TO1 */
	mxc_set_gpio_dataout(MX51_PIN_EIM_EB2, 0);      /* TO1 */

	/* Camera reset */
	mxc_set_gpio_direction(MX51_PIN_CSI1_D9, 0);
	mxc_set_gpio_dataout(MX51_PIN_CSI1_D9, 1);
	mxc_set_gpio_direction(MX51_PIN_DI1_D1_CS, 0);

	mxc_set_gpio_direction(MX51_PIN_GPIO1_0, 1);	/* SD1 CD */
	mxc_set_gpio_direction(MX51_PIN_GPIO1_1, 1);	/* SD1 WP */

	/* EIM_D16 */
	/* osc_en is shared by SPDIF */
	mxc_set_gpio_direction(MX51_PIN_EIM_D16, 0);
	mxc_set_gpio_dataout(MX51_PIN_EIM_D16, 1);
}

