/*
 * Copyright (C) 2005 - 2008 ServerEngines
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.  The full GNU General
 * Public License is included in this distribution in the file called COPYING.
 *
 * Contact Information:
 * linux-drivers@serverengines.com
 *
 * ServerEngines
 * 209 N. Fair Oaks Ave
 * Sunnyvale, CA 94085
 */
/*
 * Autogenerated by srcgen version: 0127
 */
#ifndef __post_codes_amap_h__
#define __post_codes_amap_h__

/* --- MGMT_HBA_POST_STAGE_ENUM --- */
#define POST_STAGE_POWER_ON_RESET   (0)	/* State after a cold or warm boot. */
#define POST_STAGE_AWAITING_HOST_RDY (1)	/* ARM boot code awaiting a
						go-ahed from  the host. */
#define POST_STAGE_HOST_RDY (2)	/* Host has given go-ahed to ARM. */
#define POST_STAGE_BE_RESET (3)	/* Host wants to reset chip, this is a  chip
						workaround  */
#define POST_STAGE_SEEPROM_CS_START (256)	/* SEEPROM checksum
						test start. */
#define POST_STAGE_SEEPROM_CS_DONE  (257)	/* SEEPROM checksum test
							done. */
#define POST_STAGE_DDR_CONFIG_START (512)	/* DDR configuration start. */
#define POST_STAGE_DDR_CONFIG_DONE  (513)	/* DDR configuration done. */
#define POST_STAGE_DDR_CALIBRATE_START  (768)	/* DDR calibration start. */
#define POST_STAGE_DDR_CALIBRATE_DONE   (769)	/* DDR calibration done. */
#define POST_STAGE_DDR_TEST_START   (1024)	/* DDR memory test start. */
#define POST_STAGE_DDR_TEST_DONE    (1025)	/* DDR memory test done. */
#define POST_STAGE_REDBOOT_INIT_START   (1536)	/* Redboot starts execution. */
#define POST_STAGE_REDBOOT_INIT_DONE (1537)	/* Redboot done execution. */
#define POST_STAGE_FW_IMAGE_LOAD_START (1792)	/* Firmware image load to
							DDR start. */
#define POST_STAGE_FW_IMAGE_LOAD_DONE   (1793)	/* Firmware image load
							to DDR done. */
#define POST_STAGE_ARMFW_START          (2048)	/* ARMfw runtime code
						starts execution. */
#define POST_STAGE_DHCP_QUERY_START     (2304)	/* DHCP server query start. */
#define POST_STAGE_DHCP_QUERY_DONE      (2305)	/* DHCP server query done. */
#define POST_STAGE_BOOT_TARGET_DISCOVERY_START (2560)	/* Boot Target
						Discovery Start. */
#define POST_STAGE_BOOT_TARGET_DISCOVERY_DONE (2561)	/* Boot Target
						Discovery Done. */
#define POST_STAGE_RC_OPTION_SET        (2816)	/* Remote configuration
						option is set in  SEEPROM  */
#define POST_STAGE_SWITCH_LINK          (2817)	/* Wait for link up on switch */
#define POST_STAGE_SEND_ICDS_MESSAGE    (2818)	/* Send the ICDS message
						to switch */
#define POST_STAGE_PERFROM_TFTP         (2819)	/* Download xml using TFTP */
#define POST_STAGE_PARSE_XML            (2820)	/* Parse XML file */
#define POST_STAGE_DOWNLOAD_IMAGE       (2821)	/* Download IMAGE from
						TFTP server */
#define POST_STAGE_FLASH_IMAGE          (2822)	/* Flash the IMAGE */
#define POST_STAGE_RC_DONE              (2823)	/* Remote configuration
						complete */
#define POST_STAGE_REBOOT_SYSTEM        (2824)	/* Upgrade IMAGE done,
						reboot required */
#define POST_STAGE_MAC_ADDRESS          (3072)	/* MAC Address Check */
#define POST_STAGE_ARMFW_READY          (49152)	/* ARMfw is done with POST
						and ready. */
#define POST_STAGE_ARMFW_UE             (61440)	/* ARMfw has asserted an
						unrecoverable error. The
						lower 3 hex digits of the
						stage code identify the
						unique error code.
						*/

/* This structure defines the format of the MPU semaphore
 * register when used for POST.
 */
struct BE_MGMT_HBA_POST_STATUS_STRUCT_AMAP {
	u8 stage[16];	/* DWORD 0 */
	u8 rsvd0[10];	/* DWORD 0 */
	u8 iscsi_driver_loaded;	/* DWORD 0 */
	u8 option_rom_installed;	/* DWORD 0 */
	u8 iscsi_ip_conflict;	/* DWORD 0 */
	u8 iscsi_no_ip;	/* DWORD 0 */
	u8 backup_fw;	/* DWORD 0 */
	u8 error;		/* DWORD 0 */
} __packed;
struct MGMT_HBA_POST_STATUS_STRUCT_AMAP {
	u32 dw[1];
};

/* --- MGMT_HBA_POST_DUMMY_BITS_ENUM --- */
#define POST_BIT_ISCSI_LOADED           (26)
#define POST_BIT_OPTROM_INST            (27)
#define POST_BIT_BAD_IP_ADDR            (28)
#define POST_BIT_NO_IP_ADDR             (29)
#define POST_BIT_BACKUP_FW              (30)
#define POST_BIT_ERROR                  (31)

/* --- MGMT_HBA_POST_DUMMY_VALUES_ENUM --- */
#define POST_ISCSI_DRIVER_LOADED        (67108864)
#define POST_OPTROM_INSTALLED           (134217728)
#define POST_ISCSI_IP_ADDRESS_CONFLICT  (268435456)
#define POST_ISCSI_NO_IP_ADDRESS        (536870912)
#define POST_BACKUP_FW_LOADED           (1073741824)
#define POST_FATAL_ERROR                (2147483648)

#endif /* __post_codes_amap_h__ */
