
 /************************************************************************
  * Copyright 2005-2006 by Freescale Semiconductor, Inc.
  * All modifications are confidential and proprietary information
  * of Freescale Semiconductor, Inc. ALL RIGHTS RESERVED.
  ************************************************************************/

//+-------------------------------------------------------------------------
//
//  Microsoft Windows Media
//
//  Copyright (C) Microsoft Corporation, 1999 - 1999
//
//  File:       wmaparse.h
//
//--------------------------------------------------------------------------

#ifndef WMAPARSE_H
#define WMAPARSE_H
#include "wmfdec.h"
#include "wmferr.h"
#include "wmftypes.h"
//#include <wingdi.h>
#ifdef macintosh
#include "wmMacSp.h"
#endif
#include "wmf_types.h"

#define MIN_OBJECT_SIZE     24
#define DATA_OBJECT_SIZE    50
#define MAX_PACKET_PAYLOADS 128

/*
#define FOURCC_MPG4     mmioFOURCC('M','P','G','4')
#define FOURCC_mpg4     mmioFOURCC('m','p','g','4')
#define FOURCC_MP42     mmioFOURCC('M','P','4','2')
#define FOURCC_mp42     mmioFOURCC('m','p','4','2')
#define FOURCC_MP43     mmioFOURCC('M','P','4','3')
#define FOURCC_mp43     mmioFOURCC('m','p','4','3')
#define FOURCC_MP4S     mmioFOURCC('M','P','4','S') // standard version
#define FOURCC_mp4s     mmioFOURCC('m','p','4','s')
#define FOURCC_WMV1     mmioFOURCC('W','M','V','1')
#define FOURCC_wmv1     mmioFOURCC('w','m','v','1')
#define FOURCC_MSS1     mmioFOURCC('M','S','S','1')
#define FOURCC_mss1     mmioFOURCC('m','s','s','1')
*/

#ifdef __cplusplus
extern "C" {
#endif



/****************************************************************************/
WMAERR LoadHeaderObject(
                    const U8_WMF *pbBuffer,
                    U32_WMF cbBuffer,
                    U32_WMF *pcbInternalSpace,
                    U32_WMF *pcbHeader );


/****************************************************************************/
WMAERR LoadPropertiesObject(
                    const U8_WMF *pbBuffer,
                    U32_WMF cbBuffer,
                    U32_WMF *pcbPacketSize,
                    U32_WMF *pcPackets,
                    U32_WMF *pmsDuration,
                    U32_WMF *pmsPreroll,
					U32_WMF *pdwMaxBitrate,
					U64_WMF *pcbFileSize,
					U8_WMF  *pbSeekable);


/****************************************************************************/
WMAERR LoadEncryptionObject(
                    const U8_WMF *pbBuffer,
                    U32_WMF cbBuffer,
                    U8_WMF **ppszType,
                    U8_WMF **ppszKeyID,
                    U32_WMF *pcbSecData,
                    U8_WMF **ppbSecData);

/****************************************************************************/
WMAERR LoadEncryptionObjectEx(
                    const U8_WMF *pbBuffer,
                    U32_WMF cbBuffer,
                    U32_WMF *pcbEnhData,
                    U8_WMF **ppbEnhData );


/****************************************************************************/
WMAERR LoadAudioObjectSize(
                    const U8_WMF *pbBuffer,
                    U32_WMF cbBuffer,
                    WMFDecoder *pDecoder

);


/****************************************************************************/
WMAERR ParsePacketAndPayloads(
                    const U8_WMF *pOriginalPacket,
                    U32_WMF cbOriginalPacket,
                    PACKET_PARSE_INFO_EX *pParseInfoEx,
                    U32_WMF cMaxPayloads,
                    PAYLOAD_MAP_ENTRY_EX *pPayloads );

/****************************************************************************/
WMAERR LoadContentDescriptionObject(
                    const U8_WMF *pbBuffer,
                    U32_WMF cbBuffer,
                    WMFContentDescription * ContentDescrip );

/****************************************************************************/
WMAERR LoadMarkerObject(
                    const U8_WMF *pbBuffer,
                    U32_WMF cbBuffer,
                    U32_WMF * pdwMarkerNum,
                    MarkerEntry ** ppMarkers );
/****************************************************************************/
WMAERR LoadExtendedContentDescriptionObject (
                    const U8_WMF *pbBuffer,
                    U32_WMF cbBuffer,
                    WMFExtendedContentDesc *pExtendedContentDesc );
/****************************************************************************/
WMAERR LoadScriptCommandObject (
                    const U8_WMF *pbBuffer,
                    U32_WMF cbBuffer,
                    WMFScriptCommand *pScriptCommand);
/****************************************************************************/

WMAERR
LoadLicenseStoreObject(const U8_WMF *pbBuffer,
                           U32_WMF cbBuffer,
                           U32_WMF *dwLicenseLen,
                           U8_WMF **pLicData);

/****************************************************************************/

WMAERR LoadExtendedStreamPropertiesObject(
                    const U8_WMF *pbBuffer,
                    U32_WMF cbBuffer,
                    U16_WMF *pcGoodVideoStream1,
                    U16_WMF *pcGoodVideoStream2
					);
/****************************************************************************/
WMAERR ParsePacket(
            const U8_WMF *pOriginalPacket,
            U32_WMF cbOriginalPacket,
            PACKET_PARSE_INFO_EX *pParseInfo );
/****************************************************************************/


#ifdef __cplusplus
}
#endif

#endif
