/*
***********************************************************************
* Copyright 2009-2010 by Freescale Semiconductor, Inc.
* All modifications are confidential and proprietary information
* of Freescale Semiconductor, Inc. ALL RIGHTS RESERVED.
***********************************************************************
*
*  History :
*  Date             Author              Version    Description
*
*  Oct,2009         Amanda              1.0        Initial Version
*
*/

#ifndef _FSL_PARSER_COMMON_H
#define _FSL_PARSER_COMMON_H


#ifdef __WINCE		
    //#define PARSERMSG(cond, fmt, ...) DEBUGMSG(cond, _T(fmt), __VA_ARGS__)) 
    #define PARSERMSG(fmt, ...) DEBUGMSG(1, (_T(fmt),  __VA_ARGS__)) 

#else /* linux platfom */
    #ifdef DEBUG
        #define PARSERMSG printf	
    #else
        #define PARSERMSG(fmt...) 	
    #endif		
#endif	



#define PARSER_INVALID_TRACK_NUMBER   (-1)


/*
 * Common error codes of parsers, 
 * within the range [-100 , +100].
 * Different parsers can extend the format specific errors OUTSIDE this range, 
 * in their own API header files.
 */

typedef enum
{
    PARSER_SUCCESS  = 0,
    PARSER_EOS = 1,    /* reach the end of the track/movie */
    PARSER_BOS = 2,    /* reach the beginning of the track/movie */

    /* errors */
    PARSER_ERR_UNKNOWN = -1, /* Unknow error, not captured by parser logic */
    
    PARSER_NOT_IMPLEMENTED = -5, /* the API's feature is not implemented yet */
    PARSER_ERR_INVALID_PARAMETER = -6, /* parameters are invalid */

    PARSER_INSUFFICIENT_MEMORY = -7, /* memory not enough, causing allocation or data output failure */
    PARSER_INSUFFICIENT_DATA = -8, /* data not enough, need more data */    
    
    PARSER_FILE_OPEN_ERROR = -10,    
    PARSER_READ_ERROR = -11, /* file read error, no need for further error concealment */
    PARSER_WRITE_ERROR = -12,
    PARSER_SEEK_ERROR = -13, /* file system seeking error */

    PARSER_ERR_INVALID_MEDIA = -20, /* invalid or unsupported media format */
   
    PARSER_ERR_NOT_SEEKABLE = -21, /* This file is not seekable and does not support trick mode */

    /* error concealment */
    PARSER_ERR_CONCEAL_FAIL = -22, /* Error in bitstream and no sample can be found by error concealment.
                                If the file is seekable, it's better to perform a seeking than further 
                                searching the bit stream for the next sample. */

    PARSER_ERR_MEMORY_ACCESS_VIOLATION = -25, /* internal memory access error */
    
    /* DRM */
    DRM_ERR_NOT_AUTHORIZED_USER = -140, /* Not an authorized user to play a DRM-protected file */
    DRM_ERR_RENTAL_EXPIRED = -141 /* The protected rental file is expired (reaching its view limit) */
    
}COMMON_PARSER_ERROR_CODE;


/********************************************************************* 
 * sample flags : 
 * 32-bit long, properties of a sample read.
 * The low 16 bits is reserved for common flag.
 * Parsers can use high 16 bits to define their own flags.
 ********************************************************************/
#define FLAG_SYNC_SAMPLE 0X01  /* This is a sync sample */

#define FLAG_SAMPLE_ERR_CONCEALED 0X02 /* This sample is got by error concealment, such as searching the bitstream.*/

#define FLAG_SAMPLE_SUGGEST_SEEK 0X04   /* A seeking is suggested. Although sample is got by error concealment, 
                                        A/V sync may be impacted. 
                                        If the file is seekable, a seeking on all tracks can save the A/V sync.*/
#define FLAG_SAMPLE_NOT_FINISHED 0X08   /* Sample is NOT finished at this call, large samples can be output in several calls. */

                                        

/********************************************************************* 
 * seeking flags : 
 when to seek, must set one of the following flags 
 ********************************************************************/
#define SEEK_FLAG_NEAREST 0X01  /* Default flag. The actual seeked time shall be nearest one to the given time (can be later or earlier)*/
#define SEEK_FLAG_NO_LATER  0X02    /* The actual seeked time shall be no later than the given time */
#define SEEK_FLAG_NO_EARLIER 0X03    /* The actual seeked time shall be no earlier than the given time */


/********************************************************************* 
 * direction for trick mode/sync sample reading
 ********************************************************************/
#define FLAG_BACKWARD   0X00
#define FLAG_FORWARD    0x01


/********************************************************************* 
 * User data ID
*********************************************************************/
typedef enum
{
    USER_DATA_TITLE = 0, 
    USER_DATA_LANGUAGE, /* user data may tell the language of the movie as a string */
    USER_DATA_GENRE,
    USER_DATA_ARTIST, 
    USER_DATA_COPYRIGHT,
    USER_DATA_COMMENTS,
    USER_DATA_CREATION_DATE,
    USER_DATA_RATING
    
}UserDataID;


/* 
 * Core parser memory callback funtion pointer table.
 */
typedef struct 
{  
    void* (*Calloc) (uint32 numElements, uint32 size);
    void* (*Malloc) (uint32 size);
    void  (*Free) (void * ptr);     
    void* (*ReAlloc)(void * ptr, uint32 size); /* necessary for index scanning!*/

}ParserMemoryOps; /* callback operation callback table */


#endif /* _FSL_PARSER_COMMON_H */

