/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LIBGADGET_HOST_
#define _LIBGADGET_HOST_

#include <ggadget/host_interface.h>
#include <ggadget/permissions.h>

#include "ggadget-gadget.h"

#include "libgadget-view-host.h"

class Gadget;

namespace ggadget {

using ggadget::ViewHostInterface;

class LibgadgetHost : public ggadget::HostInterface {
  
  public:
    LibgadgetHost (GGadget *gadget);
    virtual ~LibgadgetHost ();

    virtual ViewHostInterface * NewViewHost (Gadget                  *gadget,
                                             ViewHostInterface::Type  type);

    virtual Gadget * LoadGadget             (const char *path,
                                             const char *options_name,
                                             int         instance_id,
                                             bool        save_data);

    virtual void     RemoveGadget           (Gadget *gadget,
                                             bool    save_data);

    virtual bool     LoadFont               (const char *filename);

    virtual void     Run                    () { }

    virtual void     ShowGadgetDebugConsole (Gadget *gadget) { }

    virtual int      GetDefaultFontSize     ();

    virtual bool     OpenURL                (const Gadget *gadget,
                                            const char   *url);

    static void      Init                   ();

    virtual void     Draw                   (cairo_t *cr);
    virtual void     OnMainViewCloseHandler();

    Permissions global_permissions_;
    GGadget *gadget_;
    LibgadgetViewHost *lvh_;
};

} /* namespace ggadget */

#endif /* _LIBGADGET_HOST_ */
