/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <gtk/gtk.h>
#include <libgadget/libgadget.h>

#define TEST_GGADGET_PATH "/usr/share/google-gadgets/rss.gg"
//#define TEST_GGADGET_PATH "/usr/share/google-gadgets/photos.gg"


gint
main (gint argc, gchar *argv[])
{
  GadgetManager *manager;

  g_type_init ();
  gtk_init (&argc, &argv);

  manager = gadget_manager_get_default ();

  gadget_manager_load_sources (manager);

  if (gadget_manager_can_handle_path (manager, TEST_GGADGET_PATH))
  {
    GadgetProxy *clock, *clock1;

    clock = gadget_manager_load_gadget (manager,
                                        TEST_GGADGET_PATH,
                                        "try-gadget-load-1");
    g_assert (clock);

    clock1 = gadget_manager_load_gadget (manager,
                                        TEST_GGADGET_PATH,
                                        "try-gadget-load-2");

    g_assert (clock1);

    g_timeout_add (10000, (GSourceFunc)gtk_main_quit, NULL);
    gtk_main ();

    g_object_unref (clock);
    g_object_unref (clock1);
  }
  else
  {
    g_debug ("Cannot handle path: %s", TEST_GGADGET_PATH);
  }

  g_object_unref (manager);

  return 0;
}
