#!/bin/sh

test_detect_known_cpu() {
  cat <<EOF >"${MOCK_LIBMALI_MTK_GPUINFO_FILE}"
Mali-G52 1 cores r1p0 0x7402
EOF

    ( libmali_mtk_get_cpu >"${stdoutF}" 2>"${stderrF}" )
    rtrn=$?

    assertTrue "the command exited with an error" ${rtrn}
    [ ${rtrn} -eq 0 ] || showOutput
    assertEquals 'unexpected detected cpu' 'mt8365' "$(cat "${stdoutF}")"
}

test_detect_known_cpu() {
  cat <<EOF >"${MOCK_LIBMALI_MTK_GPUINFO_FILE}"
Mali-G99 99 cores r1p0 0x7402
EOF

    ( libmali_mtk_get_cpu >"${stdoutF}" 2>"${stderrF}" )
    rtrn=$?

    assertFalse "the command exited with no error" ${rtrn}
    [ ${rtrn} -eq 1 ] || showOutput
}

test_no_gpuinfo() {
    ( libmali_mtk_get_cpu >"${stdoutF}" 2>"${stderrF}" )
    rtrn=$?

    assertFalse "the command exited with no error" ${rtrn}
    [ ${rtrn} -eq 1 ] || showOutput
}

oneTimeSetUp() {
    stdoutF="${SHUNIT_TMPDIR}/stdout"
    stderrF="${SHUNIT_TMPDIR}/stderr"

    MOCK_LIBMALI_MTK_GPUINFO_FILE="${SHUNIT_TMPDIR}/gpuinfo"

    . 'debian/functions.sh'
}

setUp() {
  cp /dev/null "${stdoutF}"
  cp /dev/null "${stderrF}"
}

showOutput() {
  # shellcheck disable=SC2166
  if [ -n "${stdoutF}" -a -s "${stdoutF}" ]; then
    echo '>>> STDOUT' >&2
    cat "${stdoutF}" >&2
    echo '<<< STDOUT' >&2
  fi
  # shellcheck disable=SC2166
  if [ -n "${stderrF}" -a -s "${stderrF}" ]; then
    echo '>>> STDERR' >&2
    cat "${stderrF}" >&2
    echo '<<< STDERR' >&2
  fi
}

tearDown() {
    rm -f "${MOCK_LIBMALI_MTK_GPUINFO_FILE}"
}

. /usr/share/shunit2/shunit2
