/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#ifndef NMN_WIFI_ITEM_H
#define NMN_WIFI_ITEM_H

#include <nmn-network-item.h>
#include <nm-device-wifi.h>
#include "nmn-nm-data.h"

#define NMN_TYPE_WIFI_ITEM            (nmn_wifi_item_get_type ())
#define NMN_WIFI_ITEM(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NMN_TYPE_WIFI_ITEM, NmnWifiItem))
#define NMN_WIFI_ITEM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NMN_TYPE_WIFI_ITEM, NmnWifiItemClass))
#define NMN_IS_WIFI_ITEM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NMN_TYPE_WIFI_ITEM))
#define NMN_IS_WIFI_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), NMN_TYPE_WIFI_ITEM))
#define NMN_WIFI_ITEM_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NMN_TYPE_WIFI_ITEM, NmnWifiItemClass))

#define NMN_WIFI_ITEM_ACCESS_POINT "access-point"

typedef struct {
    NmnNetworkItem parent;
} NmnWifiItem;

typedef struct {
    NmnNetworkItemClass parent;
} NmnWifiItemClass;

GType nmn_wifi_item_get_type (void);

GtkWidget     *nmn_wifi_item_new                   (NmnNMData *nm_data,
                                                    NMDeviceWifi *device,
                                                    NMAccessPoint *ap);

GtkWidget     *nmn_wifi_item_create_for_connection (NmnNMData *nm_data,
                                                    NMDeviceWifi *device,
                                                    NMExportedConnection *exported);

void           nmn_wifi_item_set_ap                (NmnWifiItem *self,
                                                    NMAccessPoint *ap);

NMAccessPoint *nmn_wifi_item_get_ap                (NmnWifiItem *self);

#endif /* NMN_WIFI_ITEM_H */
