#!/bin/sh
# check https://docs.moodle.org/dev/Table_of_locales

## Add HP 1C12 project documentation support (bnc#730377)
docpath=/usr/share/doc/hp-documentation-sbso/platform_guides/languages/
test -d $docpath || exit 0

locale="$(echo $LANG)"
OS_LANG=en-us

case "$locale" in
    ('en_US.UTF-8') # Saudi Arabia, Latin America English, South Africa, Asia Pacific, Nordic, Adriatics, Singapore, Baltics, US (LA SP/EN), US - BTO, Arabia, Thailand, Indonesia, Euro
        OS_LANG="en-us"
        ;;
    ('ar_SA.UTF-8') #Arabic
        OS_LANG="ar"
        ;;
    ('bg_BG.UTF-8') # Bulgaria
        OS_LANG="bg"
        ;;
    ('bs_BA.UTF-8') #Bosnian
        OS_LANG="bs"
        ;;
    ('zh_CN.UTF-8') # China
        OS_LANG="cn"
        ;;
    ('zh_HK.UTF-8') # Hong Kong
        OS_LANG="cn"
        ;;
    ('cs_CZ.UTF-8') # Czech/Slovakia
        OS_LANG="cs"
        ;;
    ('da_DK.UTF-8') # Danish
        OS_LANG="da"
        ;;
    ('de_DE.UTF-8') # Germany
        OS_LANG="de"
        ;;
    ('el_GR.UTF-8') # Greece
        OS_LANG="el"
        ;;
    ('en_AU.UTF-8') # Australia / NZ
        OS_LANG="en-uk"
        ;;
    ('en_CA.UTF-8') # Canada (EN/FR)
        OS_LANG="en-us"
        ;;
    ('en_IN.UTF-8') # India
        OS_LANG="en-us"
        ;;
    ('en_GB.UTF-8') # UK - BTO
        OS_LANG="en-uk"
        ;;
    ('es_ES.UTF-8') # Spain
        OS_LANG="es-es"
        ;;
    ('es_BO.UTF-8') # Latin America
        OS_LANG="es-mx"
        ;;
    ('et_EE.UTF-8') # Estonian
        OS_LANG="et"
        ;;
    ('fi_FI.UTF-8') #Finnish
        OS_LANG="fi"
        ;;
    ('fr_FR.UTF-8') # NW Africa
        OS_LANG="fr-fr"
        ;;
    ('fr_CA.UTF-8') #French (Canada)
        OS_LANG="fr-ca"
        ;;
    ('de_CH.UTF-8') # Switzerland
        OS_LANG="gr"
        ;;
    ('he_IL.UTF-8') # Israel (Hebrew)
        OS_LANG="he"
        ;;
    ('hr_HR.UTF-8') #Croatian
        OS_LANG="hr"
        ;;
    ('hu_HU.UTF-8') # Hungary
        OS_LANG="hu"
        ;;
    ('id_ID.UTF-8') #Indonesian
        OS_LANG="id"
        ;;
    ('it_IT.UTF-8') # Italy
        OS_LANG="it"
        ;;
    ('ja_JP.UTF-8') # Japan (EN Kybrd)
        OS_LANG="ja"
        ;;
    ('ko_KR.UTF-8') # Korea
        OS_LANG="ko"
        ;;
    ('lt_LT.UTF-8') #Lithuanian
        OS_LANG="lt"
        ;;
    ('lat.UTF-8') #Latvian
        OS_LANG="lv"
        ;;
    ('nl_NL.UTF-8') # Netherlands
        OS_LANG="nl"
        ;;
    ('nl_BE.UTF-8') # Belgium
        OS_LANG="nl"
        ;;
    ('no_NO.UTF-8') #Norwegian
        OS_LANG="no"
        ;;
    ('pl_PL.UTF-8') # Poland
        OS_LANG="pl"
        ;;
    ('pt_PT.UTF-8') # Portugal
        OS_LANG="pt"
        ;;
    ('pt_BR.UTF-8') # Brazil
        OS_LANG="pt"
        ;;
    ('ro_RO.UTF-8') # Romania
        OS_LANG="ro"
        ;;
    ('ru_RU.UTF-8') # Russia
        OS_LANG="ru"
        ;;
    ('sk_SK.UTF-8') #Slovak
        OS_LANG="sk"
        ;;
    ('sl_SI.UTF-8') #Slovenian
        OS_LANG="sl"
        ;;
    ('sr_CS.UTF-8') #Serbian
        OS_LANG="sr"
        ;;
    ('sv_SE.UTF-8') #Swedish
        OS_LANG="sv"
        ;;
    ('th_TH.UTF-8') #Thai
        OS_LANG="th"
        ;;
    ('tr_TR.UTF-8') # Turkey
        OS_LANG="tr"
        ;;
    ('zh_TW.UTF-8') # Taiwan
        OS_LANG="tw"
        ;;
esac


file=$docpath/userguide-$OS_LANG.html

if [ ! -f $file ]; then
    file=$docpath/userguide-en-us.html
fi

URL="file://$file"

exec xdg-open $URL
