/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef __CMPC_QCPAPP_H__
#define __CMPC_QCPAPP_H__

#include <wx/app.h>
#include <wx/snglinst.h>
#if defined (__UNIX__)
#include "wx/string.h"
#include <string>
using namespace std;
#endif

#include "CMPC_QCPMain.h"
#include "CMPC_QCPSearchFilePath.h"

class CMPC_QCPDialog;

class CMPC_QCPApp : public wxApp
{
    public:
        virtual bool OnInit();
        virtual int OnExit();

        void FadeIn(CMPC_QCPDialog* pQCPDlg); //fade in for QCP
        void FadeOut(CMPC_QCPDialog* pQCPDlg);//fade out for QCP
        static CMPC_QCPDialog *GetInstance();
        wxString GetImageFilePath();
#if defined (__UNIX__)
        int GetLocaleFileName(int langCode, wxString& fileName);
        wxString StringToWxString(string stringValue);
        string WxStringToString(wxString wxStringValue);
#endif

    private:
        static CMPC_QCPDialog* m_Dlg;
        CSearchFilePath m_GetFilePath;
        wxImageHandler* m_pPngHandler; //the image handle of PNG form
        wxString m_strImagePath;       //Getting the image file path
        #if defined(__WXMSW__)
        wxSingleInstanceChecker *m_checker;//Check mult instance
        #endif
};

DECLARE_APP(CMPC_QCPApp)

#endif // CMPC_QCPAPP_H

