/***************************************************************************
 *Copyright (C) 2008 Inventec Corporation.
 *
 * This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 **************************************************************************/
#ifndef EVENT_ENCLUDED
#include "event.h"
#endif
int key_status=0;
int key_value=0;
int key_count=0;
extern int key;
unsigned long next_time;
int event_open(struct inode *node, struct file *filp){
	next_time=jiffies+HZ*3;
	osd_set_key_status();
	key_value=osd_get_key_status();
	return 0;
}
int event_release(struct inode *node, struct file *filp){
	return 0;
}
ssize_t event_read (struct file *filp, char __user *buff, size_t count, loff_t *fpos){
	if (time_after(jiffies, next_time)){
		next_time=jiffies+HZ*3;
		//osd_set_key_status();

		outb(0xd0, 0x72);
		outb(0x88, 0x73);
		outb(0xd1, 0x72);
		outb(0x00, 0x73);
		outb(0xd2, 0x72);
		outb(0x00, 0x73);
		outb(0xd3, 0x72);
		outb(0x00, 0x73);
		outb(0xd4, 0x72);
		outb(0x00, 0x73);
		outb(0xe5, 0xb2);
		outb(0xd1, 0x72);
		if(inb(0x73)!=0){
			key_value=0;
			return -EFAULT;
		}


		outb(0xa4, 0x600);
		outb(0x01, 0x601);
		outb(0xa1, 0x600);
		outb(0x41, 0x601);
		j1=jiffies+HZ/10;
		while(time_before(jiffies, j1)){}

	}

        outb(0xa1, 0x600);
        outb(0x18, 0x601);
        outb(0xa4, 0x600);
        key_value=inb(0x601);
	key=key_value;
	buff[0]=key_value;
	return 0;

/*
	outb(0x2a,0x600);
	key_count=inb(0x601);
	if (key_count!=0){
		outb(0xd0, 0x72);
		outb(0x81, 0x73);
		outb(0xd1, 0x72);
		outb(0x00, 0x73);
		outb(0xe5, 0xb2);
		outb(0xd0,0x72);
		while(inb(0x73)!=0){}
		outb(0xd1, 0x72);
		key_value=inb(0x73);
		key=key_value;
		buff[0]=key_value;
	}
	return 0;
*/
	
}
ssize_t event_write (struct file *filp, const char __user *buff, size_t count, loff_t *fpos){
	return count;
}
void osd_set_key_status(void){
	outb(0xd0, 0x72);
	outb(0xa9, 0x73);	
	outb(0xd1, 0x72);
	outb(0x01, 0x73);
	outb(0xe5, 0xb2);
	j1=jiffies+HZ/10;
	while(time_before(jiffies, j1)){}
}

int osd_get_key_status(void){
	outb(0xd0, 0x72);
	outb(0xaa, 0x73);
	outb(0xd1, 0x72);
	outb(0x00, 0x73);
	outb(0xd2, 0x72);
	outb(0x00, 0x73);
	outb(0xd3, 0x72);
	outb(0x00, 0x73);
	outb(0xd4, 0x72);
	outb(0x00, 0x73);
	outb(0xe5, 0xb2);
	outb(0xd1, 0x72);
	return inb(0x73);
}
