/***************************************************************************
 *Copyright (C) 2008 Inventec Corporation.
 *
 * This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 **************************************************************************/
#ifndef INIT_INCLUDED
#define INIT_INCLUDED


#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/module.h>

#include <linux/moduleparam.h> //接收參數
#include <linux/types.h> //裝置編號型別定義
#include <linux/kdev_t.h> //裝置編號處理函數，如MKDEV, MAJOR , MINOR
#include <linux/fs.h> //註冊裝置編號函數
#include <linux/cdev.h> //註冊字元裝置

#include "event.h"
#include "key.h"
#include "fan.h"
#include "wireless.h"
#include "mute.h"
#include "hibernate.h"
#include "threeg.h"

unsigned long j1;
int data;
struct cdev *event_dev, *key_dev, *fan_dev, *wireless_dev, *mute_dev, *hibernate_dev, *threeg_dev;
dev_t event_num, key_num, fan_num, wireless_num, mute_num, hibernate_num, threeg_num;
int event_major=0;
int event_minor=0;
int key_major=0;
int key_minor=0;
int fan_major=0;
int fan_minor=0;
int wireless_major=0;
int wireless_minor=0;
int mute_major=0;
int mute_minor=0;
int hibernate_major=0;
int hibernate_minor=0;
int threeg_major=0;
int threeg_minor=0;

struct file_operations event_fops={
	.owner	= THIS_MODULE,
	.open	= event_open,
	.release= event_release,
	.read	= event_read,
	.write	= event_write,
};


struct file_operations key_fops={
	.owner	= THIS_MODULE,
	.open	= key_open,
	.release= key_release,
	.read	= key_read,
	.write	= key_write,
};

struct file_operations fan_fops={
	.owner	= THIS_MODULE,
	.open	= fan_open,
	.release= fan_release,
	.read	= fan_read,
	.write	= fan_write,
};

struct file_operations wireless_fops={
	.owner	= THIS_MODULE,
	.open	= wireless_open,
	.release= wireless_release,
	.read	= wireless_read,
	.write	= wireless_write,
};
struct file_operations mute_fops={
	.owner	= THIS_MODULE,
	.open	= mute_open,
	.release= mute_release,
	.read	= mute_read,
	.write	= mute_write,
};
struct file_operations hibernate_fops={
	.owner	= THIS_MODULE,
	.open	= hibernate_open,
	.release= hibernate_release,
	.read	= hibernate_read,
	.write	= hibernate_write,
};

struct file_operations threeg_fops={
	.owner	= THIS_MODULE,
	.open	= threeg_open,
	.release= threeg_release,
	.read	= threeg_read,
	.write	= threeg_write,
};
#endif
