/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Scroller {
    DoctorPanel doctor;
    public Rectangle b;
    HScroll xscroll;
    VScroll yscroll;
    boolean xhot = false;
    boolean yhot = false;
    int fat = 15;
    Scrollable graph;
    boolean firsttime = true;

    public Scroller(DoctorPanel doctorPanel) {
        this.doctor = doctorPanel;
    }

    public void init(int n, int n2, int n3, int n4) {
        this.b = new Rectangle(n, n2, n3, n4);
        this.xscroll = new HScroll(this);
        this.xscroll.init(n, n2 + n4 - this.fat, n3 - this.fat, this.fat);
        this.yscroll = new VScroll(this);
        this.yscroll.init(n + n3 - this.fat, n2, this.fat, n4 - this.fat);
    }

    public void setFirstTime() {
        this.firsttime = true;
    }

    public void setGraph(Scrollable scrollable) {
        this.graph = scrollable;
        this.graph.setScroller(this);
    }

    public boolean scrollBarHit(int n, int n2) {
        this.yhot = false;
        this.xhot = this.xscroll.scrollBarHit(n, n2);
        if (this.xhot) {
            return true;
        }
        this.yhot = this.yscroll.scrollBarHit(n, n2);
        return this.yhot;
    }

    public boolean scrollHit(int n, int n2) {
        if (this.xscroll.scrollHit(n, n2)) {
            this.scrollXY(n - (int)this.xscroll.position, 0);
            return true;
        }
        if (this.yscroll.scrollHit(n, n2)) {
            this.scrollXY(0, n2 - this.yscroll.b.y - (int)this.yscroll.position);
            return true;
        }
        return false;
    }

    public boolean incrementHit(int n, int n2) {
        if (this.xscroll.incrementHit(n, n2)) {
            return true;
        }
        return this.yscroll.incrementHit(n, n2);
    }

    public boolean decrementHit(int n, int n2) {
        if (this.xscroll.decrementHit(n, n2)) {
            return true;
        }
        return this.yscroll.decrementHit(n, n2);
    }

    public boolean mouseHit(int n, int n2) {
        boolean bl;
        boolean bl2 = n >= this.b.x && n <= this.b.x + this.b.width;
        boolean bl3 = bl = n2 >= this.b.y && n2 <= this.b.y + this.b.height;
        if (bl2 && bl) {
            return this.graph.mouseHit(n, n2);
        }
        return false;
    }

    public boolean sameWidth() {
        Rectangle rectangle = this.graph.getRect();
        return this.b.width >= rectangle.width;
    }

    public boolean sameHeight() {
        Rectangle rectangle = this.graph.getRect();
        return this.b.height >= rectangle.height;
    }

    public void moveBy(int n, int n2) {
        Rectangle rectangle = this.graph.getRect();
        this.b.x += n;
        this.b.y += n2;
        rectangle.x += n;
        rectangle.y += n2;
        this.xscroll.b.x += n;
        this.xscroll.b.y += n2;
        this.yscroll.b.x += n;
        this.yscroll.b.y += n2;
    }

    public void scrollBy(int n, int n2) {
        double d;
        Rectangle rectangle = this.graph.getRect();
        if (this.xhot) {
            this.xscroll.scrollBy(n);
            d = this.xscroll.getPosition(rectangle.width);
            rectangle.x = (int)((double)this.b.x + d);
        }
        if (this.yhot) {
            this.yscroll.scrollBy(n2);
            d = this.yscroll.getPosition(rectangle.height);
            rectangle.y = (int)((double)this.b.y + d);
        }
    }

    public void scrollXY(int n, int n2) {
        this.xhot = true;
        this.yhot = true;
        if (n == 0) {
            this.xhot = false;
        }
        if (n2 == 0) {
            this.yhot = false;
        }
        this.scrollBy(n, n2);
    }

    public void update() {
        Rectangle rectangle = this.graph.getRect();
        this.xscroll.calculateT(rectangle.width);
        this.yscroll.calculateT(rectangle.height);
        this.xscroll.calculatePosition(rectangle.x, rectangle.width);
        this.yscroll.calculatePosition(rectangle.y, rectangle.height);
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.graph.getRect();
        if (this.firsttime) {
            rectangle.x = this.b.x;
            rectangle.y = this.b.y;
            this.xscroll.calculateT(rectangle.width);
            this.yscroll.calculateT(rectangle.height);
            this.xscroll.calculatePosition(rectangle.x, rectangle.width);
            this.yscroll.calculatePosition(rectangle.y, rectangle.height);
            this.firsttime = false;
        }
        int n = this.b.width;
        int n2 = this.b.height;
        if (rectangle.width > n && rectangle.height > n2) {
            this.xscroll.b.width = n -= this.fat;
            this.yscroll.b.height = n2 -= this.fat;
            graphics.setColor(Color.lightGray);
            graphics.fillRect(this.b.x + this.b.width - this.fat, this.b.y + this.b.height - this.fat, this.fat, this.fat);
        } else if (rectangle.width > n) {
            n2 -= this.fat;
            this.xscroll.b.width = n;
        } else if (rectangle.height > n2) {
            n -= this.fat;
            this.yscroll.b.height = n2;
        }
        if (rectangle.width > this.b.width) {
            this.xscroll.draw(graphics);
        }
        if (rectangle.height > this.b.height) {
            this.yscroll.draw(graphics);
        }
        graphics.clipRect(this.b.x, this.b.y, n, n2);
        if (this.graph != null) {
            this.graph.draw(graphics);
        }
    }
}

